<CsoundSynthesizer>
<CsInstruments>

sr        =         44100
kr        =         441
ksmps     =         100
nchnls  =       1


instr   4

gkpit   rand    .005

endin



instr   1

ilast   =       2

iseed   =       p6

ivib    =       .03*iseed

ivoi    =       p8


krik    rand    8,.38413*iseed

kpik    rand     2,.5765*iseed


newvalue:


idu     table   i(krik) ,34,0,0,1

ipi     table   i(kpik)+ilast,33,0,0,1

kpi     =       cpspch(ipi+p11)

ipo     =       cpspch(ipi+p11)

kvibenv expseg  ipo*.001,1.5,ipo*ivib,idu-2,ipo*ivib, .5, ipo*.015

kbend   rand    .3,.89*iseed

kford   rand    1.5,.0345*iseed

ibend   =       (i(kbend)+.33)*(i(kbend)+.33)+.02

igli    =       (idu/2)+.2

ishifsp =       (i(kford)+1.5)*((i(kford)+1.5)/idu)+.2

ilast   =       i(kpik)+ilast


timout  0,idu,go

reinit  newvalue

rireturn

go:

kpi     port    kpi,ibend,cpspch(ipi+p11)

kam     randh   .45, 1,.46543*iseed

kam     port    kam+.55,.5,p7



kshif   randh   5,ishifsp,-.4478*iseed

kshif   =       int(kshif+5)*9


kind    =       kshif

kif0    =       kpi *(1+i(gkpit))

iind    =       (p5*9)-9


ifif1   table   iind,ivoi,0

ifif2   table   iind+1,ivoi,0

ifif3   table   iind+2,ivoi,0

iria1   table   iind+3,ivoi,0

iria2   table   iind+4,ivoi,0

iria3   table   iind+5,ivoi,0


kdev1   table   kind+6,ivoi,0

kdev2   table   kind+7,ivoi,0

kdev3   table   kind+8,ivoi,0


kdev1   randh   kdev1/2,ishifsp,.0980*iseed

kdev2   randh   kdev2/2,ishifsp,.6983*iseed

kdev3   randh   kdev3/2,ishifsp,.4*iseed


kfif1   table   kind,ivoi,0

kfif2   table   kind+1,ivoi,0

kfif3   table   kind+2,ivoi,0

kria1   table   kind+3,ivoi,0

kria2   table   kind+4,ivoi,0

kria3   table   kind+5,ivoi,0



kif1    port    kfif1+kdev1,igli,ifif1

kif2    port    kfif2+kdev2,igli,ifif2

kif3    port    kfif3+kdev3,igli,ifif3

kia1    port    kria1-10,igli,iria1

kia2    port    kria2,igli,iria2

kia3    port    kria3,igli,iria3


krandvib randi  .2,3.5,iseed*.123

; kvibenv expseg p4*.001,1.5,p4*ivib,p3-.35,p4*ivib,1,p4*.015

kvib    oscil   kvibenv,5.5*(1+krandvib),4



kenv    linseg  0.001,.1+p3*.1,1,p3-(.2+p3*.25),1,.1+p3*.15,0.001


kdev    randi   .009,12,iseed*.765

kdev    =       1+kdev

kpit    linseg  .95,.1,1,p3-.2,1,.1,0.92



kpitch  =       kdev*kif0*kpit+kvib


ar      fof     ampdb(kia1)*kenv*kam, kpitch, kif1, 0, 50, .0025, .025, .007, 50, 1, 2, p3

ar1     fof     ampdb(kia2)*kenv*kam*kam, kpitch, kif2, 0, 100, .0025, .025, .007, 50, 1, 2, p3

ar2     fof     ampdb(kia3)*kenv*kam*kam*kam, kpitch, kif3, 0, 150, .0025, .025, .007, 50, 1, 2, p3

ar3     fof     ampdb(kia3)*kenv*kam*kam*kam*.7, kpitch, kif3+1000, 0,150, .0025, .025, .007, 50, 1, 2, p3


out     (ar+ar1+ar2)+ar3

endin


instr   15

kmod    expseg  p5,.0151,p5*.1,p3*0.9,.005

asid    foscil  ampdb(p5),cpspch(p4),2.380,3.967,kmod,1

agon     expseg 0.001,.0151,1,.1,.7,p3*0.9,.005

out     (asid)*agon

endin


</CsInstruments>
<CsScore>
f1 0 8192 10 1

f2 0 8192 19 .25 1 0 0

f3 0 8192 10 2 0 0 0 0 0 0 0 0 .1 .1 0 0 .1

f4 0 8192 7 0 2048 1 4096 -1 2048 0

;formant homme

f99 0 128 -2 738 1115 2450 80 70 60 73 110 266 677 1717 2404 80 70 55 80 162 183 634 1217 2388 80 70 50 58 144 230 543 789 2384 80 70 30 73 146 323 535 1868 2498 80 70 60 65 150 168 489 1358 1706 80 65 40 80 146 233 386 1977 2564 80 70 50 94 196 155 267 2290 2933 80 65 60 53 233 266 440 1032 2241 80 60 40 76 185 246 304 870 2239 80 65 40 63 250 483 ;formant femme

f89 0 128 -2 877.324 1235.11 2749.51 80 70 60 103.0 118.333 296.667 901.136 2024.02 2832.39 80 70 65 123.333 175.333 243.333 756.886 1418.48 2768.64 80 70 50 100.667 176.0 290.0 583.646 906.042 2735.29 80 50 40 113.333 173.333 350.0 607.167 2367.79 3016.24 70 60 60 100.0 156.667 200.0 503.704 1632.04 1969.39 80 60 50 97.3333 266.667 333.333 437.378 2498.78 3082.44 80 60 50 71.6667 160.0 200.0 307.792 2782.17 3316.23 80 55 60 62.0 246.667 318.333 459.023 1141.84 2673.75 80 60 50 78.3333 215.333 296.667 378.113 962.245 2659.72 80 65 40 66.6667 266.667 280.0 ;formant enfant

f79 0 128 -2 1089.17 1402.5 3175.0 80 70 60 96.6667 133.333 616.667 1047.89 2288.15 3342.96 80 70 55 164.0 250.0 473.333 858.304 1589.13 3302.61 80 70 50 146.667 130.0 386.667 702.187 1074.37 3230.62 80 70 30 130.0 136.667 450.0 684.312 2613.44 3448.75 80 70 60 95.0 208.333 186.667 569.276 1808.1 2184.83 80 65 40 125.0 266.667 400.0 534.412 2795.88 3528.24 80 64 40 100.0 256.667 413.333 360.2 3177.83 3763.0 80 65 50 105.0 293.333 306.667 553.889 1400.19 3312.22 80 55 40 93.3333 166.667 400.0 423.964 1177.14 3245.0 80 65 40 106.667 350.0 366.667 ;Table hauteur

f33 0 32 -2 6.0 6.02 6.03 6.05 6.07 6.09 6.10 7.0 6.10 6.07 7.0 7.02 7.03 7.05 7.07 7.03 7.0 6.10 6.09 6.07 6.05 6.04 6.0 6.03 6.05 6.10 6.05 6.07 6.03 6.02 6.0 5.10 ;Table rythme

f34 0 16 -2 .50 .0375 .0375 .0625 8 .0375 3 .125 .125 4 2 .0625 .25 1 .125


t 0 30


i4 0.0 140

i1 0.0 0 100 3 0.31828157 .260 89 2 3 2.05

i1 2.0 6 100 2 0.78397649 .260 89 2 3 2.05

i1 7.0 4 100 3 0.17993278 .260 89 2 3 2.05

i1 13.0 2 100 6 0.61303195 .260 89 2 3 2.05

i1 19.0 7 100 2 0.45055681 .260 89 2 3 2.05

i1 20.0 1 100 7 0.52778859 .260 89 2 3 2.05

i1 27.0 6 100 4 0.52658303 .260 89 2 3 2.05

i1 33.0 0 100 8 0.83882157 .260 89 2 3 2.05

i1 40.0 1 100 2 0.97642262 .260 89 2 3 2.05

i1 41.0 4 100 5 0.34094294 .260 89 2 3 2.05

i1 43.0 0 100 10 0.9152293 .260 89 2 3 2.05

i1 44.0 2 100 6 0.18855478 .260 89 2 3 2.05

i1 50.0 6 100 4 0.38011582 .260 89 2 3 2.05

i1 53.0 3 100 8 0.77036441 .260 89 2 3 2.05

i1 59.0 5 100 3 0.70518818 .260 89 2 3 2.05

i1 66.0 5 100 8 0.58428177 .260 89 2 3 2.01

i1 72.0 3 100 7 0.89621511 .260 89 2 3 2.01

i1 76.0 4 100 8 0.11277273 .260 89 2 3 2.01

i1 79.0 7 100 1 0.0058446489 .260 89 2 3 2.01

i1 84.0 3 100 7 0.69775647 .260 89 2 3 2.01

i1 86.0 4 100 1 0.50891174 .260 89 2 3 2.01

i1 89.0 0 100 2 0.4152295 .260 89 2 3 2.01

i1 95.0 4 100 9 0.6767432 .260 89 2 3 2.01

i1 98.0 0 100 6 0.95089234 .260 89 2 3 2.01

i1 101.0 4 100 9 0.95273882 .260 89 2 3 2.01

i1 108.0 4 100 4 0.47450004 .260 89 2 3 2.01

i1 112.0 3 100 3 0.32704092 .260 89 2 3 2.01

i1 118.0 8 100 4 0.51548888 .260 89 2 3 2.01

i1 120.0 8 100 8 0.71193318 .8 79 8 8 2.04

i1 0.0 0 100 7 0.49311746 0.51857164 99 7 10 1.05

i1 2.0 6.0 100 3 0.50558502 0.79607038 99 2 8 1.05

i1 10.0 0.0 100 5 0.27675862 0.93045916 99 5 9 1.05

i1 16.0 3.0 100 7 0.53741776 0.62691129 99 7 9 1.05

i1 22.0 2.0 100 1 0.032809387 0.73865396 99 7 4 1.05

i1 26.0 4.0 100 6 0.71452741 0.79994647 99 10 11 1.05

i1 34.0 4.0 100 4 0.16560347 0.92664411 99 7 7 1.05

i1 42.0 2.0 100 7 0.32395836 0.61491679 99 2 7 1.05

i1 46.0 0.0 100 2 0.31377982 0.84495637 99 5 5 1.05

i1 54.0 1.5 100 10 0.94983938 0.77012808 99 5 4 1.05

i1 56.0 1.8 100 3 0.22536234 0.64887832 99 8 4 1.05

i1 58.0 0 100 4 0.84787086 0.54969478 99 8 5 1.05

i1 62.0 3.0 100 6 0.63283966 0.73590712 99 4 4 1.01

i1 66.0 0.0 100 3 0.32081476 0.5112849 99 11 9 1.01

i1 68.0 3.0 100 3 0.12788031 0.68315268 99 2 4 1.01

i1 74.0 1.0 100 1 0.093346521 0.67345484 99 5 10 1.01

i1 76.0 4.0 100 3 0.036777034 0.68496864 99 5 2 1.01

i1 84.0 1.5 100 5 0.68699804 0.70316641 99 5 10 1.01

i1 86.0 3.0 100 2 0.29507084 0.99040114 99 5 5 1.01

i1 90.0 1.5 100 10 0.7950096 0.60334957 99 10 5 1.01

i1 92.0 0.0 100 2 0.32263073 0.84059196 99 5 7 1.01

i1 100.0 0.0 100 10 0.65763746 0.90041949 99 2 11 1.01

i1 108.0 1.8 100 7 0.8988246 0.90650067 99 7 4 1.01

i1 110.0 3.0 100 3 0.43700577 0.83161134 99 7 9 1.01

i1 115.0 1.0 100 3 0.3700577 0.7161134 99 7 9 1.01

i1 118.0 5.0 100 3 0.660577 0.8961134 99 7 9 1.01

i15 0.0 15 4.105 50.136655

i15 4.0 15 4.01 62.780553

i15 8.0 15 4.105 58.308939

i15 11.0 15 4.105 61.351743

i15 16.0 15 4.0745 53.336715

i15 20.0 15 4.01 59.040283

i15 24.0 15 4.078 51.950022

i15 28.0 15 4.078 58.160839

i15 30.0 15 4.047 54.705553

i15 34.0 15 4.105 64.54402

i15 39.0 15 4.01 51.612162

i15 43.0 15 4.0745 55.658475

i15 47.0 15 4.0745 57.759115

i15 51.0 15 4.0745 53.742559

i15 54.0 15 4.0745 58.936133

i15 59.0 15 4.0745 63.923693

i15 64.0 15 4.0745 62.263004

i15 68.0 15 4.0745 57.341825

i15 72.0 15 4.01 56.811

i15 77.0 15 4.078 59.282462

i15 80.0 15 4.078 64.232483

i15 84.0 15 4.0745 57.293298

i15 87.0 15 4.047 54.378222

i15 90.0 15 4.01 59.314509

i15 94.0 15 4.01 55.932471

i15 99.0 15 4.105 61.80085

i15 102.0 15 4.0745 57.028915

i15 105.0 15 4.047 62.847851

i15 110.0 15 4.047 55.880281

i15 113.0 15 4.01 60.316645

i15 116.0 15 4.01 51.402487

i15 30.0 2 9.0007395 38.818097

i15 30.109947 2 9.0045418 39.373186

i15 30.218402 2 9.0048352 45.618796

i15 30.313127 2 9.0038574 48.153436

i15 30.403648 2 9.0020833 36.740576

i15 30.502953 2 9.0015261 37.401876

i15 30.607394 2 9.0008343 46.14161

i15 30.701976 2 9.0049998 47.756976

i15 30.809489 2 9.0012345 49.415376

i15 30.908134 2 9.0013378 39.928046

i15 31.003617 2 9.0046026 36.922325

i15 31.097881 2 9.0040863 35.333053

i15 31.187911 2 9.002803 41.91744

i15 31.294314 2 9.0001484 46.7173

i15 31.400588 2 9.0026234 48.666865

i15 31.500295 2 9.0016639 38.774834

i15 31.600559 2 9.0001474 35.576835

i15 31.696574 2 9.0028803 38.783533

i15 31.79307 2 9.0001314 48.325342

i15 31.884919 2 9.0020298 37.221043

i15 31.980319 2 9.0003778 47.973289

i15 32.07624 2 9.0032047 38.394398

i15 32.177081 2 9.0011114 44.101629

i15 32.28371 2 9.0032308 36.062795

i15 32.391336 2 9.0043537 47.932087

i15 32.500895 2 9.0035438 49.065842

i15 32.60989 2 9.0032976 40.449258

i15 32.704871 2 9.0020634 36.940866

i15 32.808999 2 9.0016835 45.532271

i15 32.904361 2 9.0000691 40.560733

i15 33.010005 2 9.003174 38.071416

i15 33.112852 2 9.004075 37.745688

i15 33.219948 2 9.0007273 47.102544

i15 33.326721 2 9.0027033 38.897068

i15 33.417196 2 9.000975 48.92232

i15 33.508356 2 9.003562 47.618719

i15 33.602071 2 9.0035947 40.219897

i15 33.694295 2 9.0001173 36.339768

i15 33.792475 2 9.0006853 36.201739

i15 33.888337 2 9.0035714 41.948341

i15 33.984511 2 9.0011442 38.713717

i15 34.079669 2 9.0047341 36.404776

i15 34.178111 2 9.0000392 49.367307

i15 34.286 2 9.0009 37.376697

i15 34.387662 2 9.0029861 37.661681

i15 34.481671 2 9.0027243 38.857697

i15 34.577621 2 9.0005211 44.11811

i15 34.670795 2 9.001095 46.795585

i15 34.763158 2 9.0024792 43.392489

i15 34.865375 2 9.0040108 39.713793

i15 34.955767 2 9.0023655 47.409731

i15 35.048426 2 9.0034533 49.34373

i15 35.153895 2 9.0017329 43.483134

i15 35.262112 2 9.0022647 46.239351

i15 35.358568 2 9.0045565 37.443307

i15 35.460851 2 9.0010211 35.41088

i15 35.554013 2 9.0016069 36.761635

i15 35.649459 2 9.0049087 46.94895

i15 35.753287 2 9.0048285 48.675105

i15 35.846267 2 9.000596 36.640546

i15 35.948901 2 9.0017104 48.308403

i15 36.051246 2 9.0031138 41.608192

i15 36.148441 2 9.0046658 36.804211

i15 36.239129 2 9.0027248 35.921791

i15 36.335199 2 9.0004026 39.448037

i15 36.437548 2 9.0018023 41.233707

i15 36.533795 2 9.0043029 43.787575

i15 36.630141 2 9.0017039 42.396075

i15 36.720799 2 9.0047935 42.761633

i15 36.824694 2 9.0046465 38.090415

i15 36.920364 2 9.0027241 47.826334

i15 37.026256 2 9.0005804 46.453147

i15 37.124843 2 9.0007413 42.07584

i15 37.215264 2 9.0040675 35.694262

i15 37.320416 2 9.002664 38.372652

i15 37.410675 2 9.0011515 49.73378

i15 37.517719 2 9.0028567 47.469703

i15 37.618086 2 9.0012374 48.812218

i15 37.727465 2 9.0006066 46.132454

i15 37.822856 2 9.0039639 35.127041

i15 37.921069 2 9.0044984 35.26919

i15 38.028238 2 9.0010784 43.45681

i15 38.136278 2 9.0017868 38.055851

i15 38.238499 2 9.0033141 41.777122

i15 38.347786 2 9.0027755 38.055393

i15 38.447047 2 9.0022622 41.895694

i15 38.542868 2 9.0001885 37.348084

i15 38.649556 2 9.0022493 45.072406

i15 38.742005 2 9.003548 39.654965

i15 38.84209 2 9.0022107 47.644814

i15 38.944502 2 9.0035466 48.462683

i15 39.04423 2 9.0025664 46.653665

i15 39.139119 2 9.0014247 35.145582

i15 39.247197 2 9.0020956 45.468407

i15 39.339695 2 9.0033449 42.100104

i15 39.446977 2 9.0048124 44.411335

i15 39.545771 2 9.0047658 45.857313

i15 39.642445 2 9.0018389 46.383102

i15 39.748215 2 9.0048181 45.215928

i15 39.838496 2 9.0032836 47.486871

i15 39.939848 2 9.0006794 44.365783

i15 40.034163 2 9.0001124 42.65382

i15 40.131073 2 9.0019501 36.011292

i15 40.235744 2 9.0010272 46.270024

i15 40.330493 2 9.0000259 44.500378

i15 40.434929 2 9.0043385 37.796504

i15 40.530539 2 9.002476 48.942463

i15 40.631922 2 9.0048408 42.401569

i15 40.738096 2 9.0024148 41.338774

i15 40.843571 2 9.000688 46.578127

i15 40.950128 2 9.0028797 39.708529

i15 41.056486 2 9.0002697 48.773304

i15 41.154299 2 9.0012046 41.209672

i15 41.245167 2 9.004084 35.011216

i15 41.354604 2 9.0033958 35.265069

i15 41.455135 2 9.0016123 44.523955

i15 41.56199 2 9.0035056 46.691434

i15 41.671047 2 9.0031974 40.364793

i15 41.769984 2 9.0030085 43.815959

i15 41.869826 2 9.0019148 35.044636

i15 41.975313 2 9.0001761 41.61071

i15 42.078787 2 9.0004503 36.152067

i15 42.183534 2 9.0044525 39.811993

i15 42.27876 2 9.0029741 36.97749

i15 42.379655 2 9.0008265 36.046543

i15 42.472214 2 9.002015 37.140011

i15 42.563765 2 9.0042117 38.957728

i15 42.656387 2 9.0003369 48.212951

i15 42.751656 2 9.003816 36.327636

i15 42.861408 2 9.0028131 39.343887

i15 42.960448 2 9.0025205 38.206011

i15 43.053415 2 9.0033007 47.88974

i15 43.159211 2 9.0012532 45.032348

i15 43.262696 2 9.0015163 35.028613

i15 43.364597 2 9.0033638 45.760716

i15 43.456796 2 9.0049119 41.398975

i15 43.561458 2 9.0039985 45.98733

i15 43.658657 2 9.0005467 42.711503

i15 43.768477 2 9.0044757 36.072638

i15 43.869734 2 9.001967 45.382798

i15 43.968788 2 9.0016603 49.271626

i15 44.078121 2 9.0010762 47.156793

i15 44.185606 2 9.0023401 39.847701

i15 44.291681 2 9.0000134 42.730273

i15 44.382843 2 9.0025988 46.21257

i15 44.476162 2 9.0030268 44.379746

i15 44.570744 2 9.0021921 39.037386

i15 44.678337 2 9.0033483 42.58286

i15 44.77651 2 9.0039231 39.388523

i15 44.874111 2 9.0000697 41.646648

i15 44.979914 2 9.0030159 41.845564

i15 45.08166 2 9.0000176 35.330307

i15 45.173933 2 9.0014921 42.628869

i15 45.279546 2 9.0046279 42.473444

i15 45.370375 2 9.0025456 37.7244

i15 45.469849 2 9.0018192 37.614756

i15 45.5705 2 9.0049162 36.009919

i15 45.666292 2 9.002872 46.625739

i15 45.760646 2 9.0022657 42.37845

i15 45.867361 2 9.0042996 47.326639

i15 45.972855 2 9.0025536 40.86174

i15 46.074432 2 9.0047249 35.117427

i15 46.170494 2 9.0024107 37.759193

i15 46.274898 2 9.0017551 43.604681

i15 46.378887 2 9.0015144 44.761327

i15 46.470291 2 9.0038578 45.21753

i15 46.560931 2 9.0019647 47.071871

i15 46.669411 2 9.0022334 46.841366

i15 46.777735 2 9.002658 46.536696

i15 46.886449 2 9.0026929 35.437891

i15 46.994228 2 9.0036626 44.767278

i15 47.104108 2 9.002531 43.676099

i15 47.209794 2 9.0005933 41.265525

i15 47.301733 2 9.002402 35.546849

i15 47.393894 2 9.0039882 46.549972

i15 47.488435 2 9.0031948 47.000682

i15 47.586697 2 9.0036805 35.276514

i15 47.681218 2 9.0029071 41.559665

i15 47.784697 2 9.0031761 49.372801

i15 47.8881 2 9.0035217 35.953838

i15 47.991342 2 9.0040281 46.149393

i15 48.096238 2 9.00288 45.741259

i15 48.192655 2 9.0002104 46.438268

i15 48.285055 2 9.0015583 45.929417

i15 48.377865 2 9.0024956 42.709443

i15 48.484367 2 9.0047426 36.60621

i15 48.585031 2 9.0028263 42.199906

i15 48.677503 2 9.0041022 48.565461

i15 48.77166 2 9.003693 35.035709

i15 48.869434 2 9.0046666 43.922856

i15 48.970341 2 9.0025074 37.360902

i15 49.079898 2 9.0016993 41.752401

i15 49.189367 2 9.0009788 44.45826

i15 49.281519 2 9.0025739 48.705091

i15 49.378352 2 9.0044885 43.875473

i15 49.482941 2 9.0036474 49.633063

i15 49.578873 2 9.0014631 43.55272

i15 49.676947 2 9.0021365 43.217836

i15 49.780078 2 9.0027534 39.944756

i15 49.873586 2 9.0029928 47.595829

i15 49.979322 2 9.001005 46.148477

i15 50.078299 2 9.0007762 45.978402

i15 50.187787 2 9.0000368 45.023649

i15 50.29504 2 9.0015324 37.281473

i15 50.401107 2 9.0042143 47.323206

i15 50.494403 2 9.0046654 41.751027

i15 50.594993 2 9.0028236 44.813974

i15 50.68675 2 9.0048136 46.583163

i15 50.785862 2 9.0044496 38.404241

i15 50.880334 2 9.0037251 41.55234

i15 50.976459 2 9.0013473 36.268579

i15 51.084423 2 9.0021324 39.638255

i15 51.186483 2 9.0038205 36.97131

i15 51.277423 2 9.0016274 37.64726

i15 51.368205 2 9.0045932 42.592703

i15 51.460009 2 9.0015363 36.839233

i15 51.567107 2 9.0031866 41.852431

i15 51.673247 2 9.0007945 48.5531

i15 51.767495 2 9.0002944 38.237142

i15 51.861715 2 9.0048224 39.826871

i15 51.963128 2 9.0021572 48.125281

i15 52.061635 2 9.0023984 44.032729

i15 52.152844 2 9.0049368 38.906453

i15 52.253992 2 9.0025368 46.491602

i15 52.361186 2 9.0040919 47.117193

i15 52.462665 2 9.0013604 35.102777

i15 52.56402 2 9.0037535 41.553484

i15 52.657544 2 9.003977 35.97215

i15 52.75917 2 9.0010993 41.406529

i15 52.862665 2 9.0013527 44.030898

i15 52.962036 2 9.0007293 39.38074

i15 53.069325 2 9.0021895 43.662365

i15 53.166222 2 9.00404 44.822673

i15 53.274213 2 9.0047976 44.330303

i15 53.369159 2 9.0035991 36.841751

i15 53.462534 2 9.0039715 41.200287

i15 53.562731 2 9.0025222 37.441934

i15 53.656135 2 9.0028659 35.766595

i15 53.748902 2 9.0038466 49.641074

i15 53.846627 2 9.0048698 41.477718

i15 53.940338 2 9.0049061 40.594382

i15 54.033511 2 9.0004802 44.357771

i15 54.126032 2 9.0017062 44.728823

i15 54.227306 2 9.0041809 38.634746

i15 54.321934 2 9.0033005 41.857009

i15 54.417669 2 9.0013125 47.367384

i15 54.526568 2 9.0011627 45.310235

i15 54.626527 2 9.0049522 38.062489

i15 54.721661 2 9.0035651 40.057834

i15 54.82619 2 9.0027844 48.311379

i15 54.917771 2 9.0049506 40.837477

i15 55.02249 2 9.0039801 41.401722

i15 55.124909 2 9.0003089 45.2759

i15 55.222898 2 9.0010677 46.955359

i15 55.328161 2 9.0045535 47.015103

i15 55.429651 2 9.0018116 46.542876

i15 55.528318 2 9.001892 48.838542

i15 55.637874 2 9.0010845 39.314587

i15 55.747501 2 9.0002059 45.794594

i15 55.83871 2 9.002744 47.626044

i15 55.939779 2 9.000423 38.322752

i15 56.047444 2 9.0015066 47.656717

i15 56.146806 2 9.0008929 45.379822

i15 56.256624 2 9.004824 35.040974

i15 56.358434 2 9.0017619 42.559283

i15 56.454188 2 9.0047561 45.49496

i15 56.558344 2 9.0043487 35.222951

i15 56.666593 2 9.0048481 40.431174

i15 56.774672 2 9.0005176 41.624444

i15 56.866933 2 9.002004 47.596287

i15 56.975629 2 9.0020569 46.029906

i15 57.06807 2 9.0033633 46.685712

i15 57.170131 2 9.0000497 41.846938

i15 57.260755 2 9.0031733 49.975959

i15 57.353423 2 9.0042529 44.750797

i15 57.456757 2 9.0046668 47.944677

i15 57.557704 2 9.0024679 45.805123

i15 57.656985 2 9.0019351 44.898897

i15 57.747747 2 9.0049203 39.589499

i15 57.84461 2 9.0018049 49.599185

i15 57.941532 2 9.003631 37.325651

i15 58.043199 2 9.0007115 35.881046

i15 58.135864 2 9.0017935 50.00091

i15 58.239831 2 9.0015751 38.288645

i15 58.337005 2 9.0031485 41.488934

i15 58.433226 2 9.0006746 37.689378

i15 58.536291 2 9.0013574 46.685483

i15 58.626871 2 9.0045243 41.906223

i15 58.730764 2 9.00438 49.622304

i15 58.827145 2 9.0017461 46.339153

i15 58.928793 2 9.0038463 41.597434

i15 59.026438 2 9.0049488 39.590644

i15 59.1207 2 9.0044346 49.302756

i15 59.211284 2 9.002598 39.093925

i15 59.314386 2 9.0032442 42.940635

i15 59.415483 2 9.0008954 36.733022

i15 59.515955 2 9.0041718 39.358307

i15 59.618223 2 9.0006517 49.472373

i15 59.715337 2 9.0022855 40.16725

i15 59.807208 2 9.004162 49.975501

i15 59.916918 2 9.003201 44.869369

i15 60.026788 2 9.0020797 47.237367

i15 60.135162 2 9.0024549 48.981835

i15 60.23107 2 9.0002941 47.205779

i15 60.335231 2 9.0048817 42.161908

i15 60.442057 2 9.0018035 43.405536

i15 60.538622 2 9.0039867 36.334503

i15 60.632766 2 9.00359 37.565313

i15 60.733781 2 9.0013228 48.815651

i15 60.835357 2 9.0034953 45.243167

i15 60.931735 2 9.0008648 40.431861

i15 61.034253 2 9.0020955 41.446587

i15 61.126711 2 9.0033844 48.657251

i15 61.224267 2 9.0045766 41.264838

i15 61.321767 2 9.0008242 35.724706

i15 61.413731 2 9.0026079 45.489008

i15 61.519412 2 9.0006751 36.764382

i15 61.612615 2 9.0012191 46.23752

i15 61.717233 2 9.000349 37.917594

i15 61.825657 2 9.0006738 47.58301

i15 61.928524 2 9.001555 49.468482

i15 62.030482 2 9.0033454 41.175108

i15 62.127901 2 9.004674 43.963372

i15 62.220731 2 9.0005905 41.868683

i15 62.321937 2 9.0031332 44.343808

i15 62.414191 2 9.004627 48.345256

i15 62.504782 2 9.0027827 47.064546

i15 62.605908 2 9.0004046 48.738511

i15 62.698791 2 9.0012687 35.219747

i15 62.806323 2 9.0024853 41.261176

i15 62.900146 2 9.00241 36.673279

i15 63.004391 2 9.0019132 39.830534

i15 63.109481 2 9.0005713 47.176708

i15 63.215708 2 9.003093 49.691204

i15 63.307508 2 9.0000401 43.495495

i15 63.415634 2 9.0006628 43.037918

i15 63.515644 2 9.0044007 41.539292

i15 63.617421 2 9.0013714 39.647869

i15 63.721633 2 9.0009078 49.482674

i15 63.815338 2 9.0009506 37.499389

i15 63.910171 2 9.0048656 35.887227

i15 64.012792 2 9.0009926 48.400193

i15 64.118536 2 9.0039974 47.837321

i15 64.215457 2 9.0008234 43.607428

i15 64.317203 2 9.0028253 44.049897

i15 64.409397 2 9.0043788 49.461386

i15 64.515482 2 9.0020426 43.012968

i15 64.624195 2 9.0020781 48.001444

i15 64.732132 2 9.0028897 46.103612

i15 64.841069 2 9.0027011 42.597052

i15 64.950991 2 9.0015283 35.712803

i15 65.046005 2 9.0002612 48.57187

i15 65.141596 2 9.003418 48.377074

i15 65.24788 2 9.0008818 38.82382

i15 65.344821 2 9.002689 37.891041

i15 65.441587 2 9.0046705 39.458796

i15 65.543486 2 9.0015193 38.447275

i15 65.63616 2 9.0025931 45.407977

i15 65.737992 2 9.0045089 42.750188

i15 65.847898 2 9.0033517 41.054705

i15 65.946944 2 9.0030536 45.144968

i15 66.038488 2 9.0002561 35.862734

i15 66.13277 2 9.0047223 39.742406

i15 66.238138 2 9.0031023 39.999006

i15 66.332358 2 9.0026296 48.546462

i15 66.433692 2 9.0000434 39.95643

i15 66.53267 2 9.0048135 44.572253

i15 66.641763 2 9.0044693 49.183498

i15 66.751374 2 9.0036072 39.979092

i15 66.846852 2 9.0018768 38.702959

i15 66.94246 2 9.0000166 39.191208

i15 67.044476 2 9.001749 47.746905

i15 67.146878 2 9.0030954 37.022584

i15 67.249294 2 9.004428 39.368608

i15 67.348153 2 9.0043173 46.804512

i15 67.448229 2 9.0029891 41.080342

i15 67.553013 2 9.0019536 38.504958

i15 67.658597 2 9.0001182 45.469323

i15 67.757015 2 9.0004482 41.862961

i15 67.851225 2 9.004986 45.825953

i15 67.955168 2 9.0047917 39.50389

i15 68.058587 2 9.0001203 41.76934

i15 68.15756 2 9.0048953 40.07111

i15 68.247916 2 9.0032864 44.872802

i15 68.349982 2 9.0049684 46.34808

i15 68.459343 2 9.0043562 39.285287

i15 68.559555 2 9.0028917 38.381808

i15 68.669008 2 9.0021873 47.362348

i15 68.76535 2 9.0045933 46.614523

i15 68.857193 2 9.0014968 45.283454

i15 68.954015 2 9.0034224 44.998928

i15 69.06145 2 9.0047361 43.68434

i15 69.160408 2 9.0045259 39.131236

i15 69.254716 2 9.003965 48.278417

i15 69.353207 2 9.0042217 49.374632

i15 69.448447 2 9.0027287 35.479551

i15 69.545548 2 9.0043754 48.97863

i15 69.640739 2 9.0029319 48.03578

i15 69.750646 2 9.0017737 37.210742

i15 69.849455 2 9.0017127 35.639783

i15 69.942414 2 9.0025011 37.481305

i15 70.050344 2 9.0033198 40.570805

i15 70.141098 2 9.0013131 35.462841

i15 70.240174 2 9.0009848 38.305126

i15 70.343894 2 9.0010127 37.220356

i15 70.444854 2 9.0038005 48.151147

i15 70.540577 2 9.0018244 37.333434

i15 70.632557 2 9.0035922 48.866697

i15 70.734128 2 9.0007694 47.023801

i15 70.83185 2 9.0017956 44.290016

i15 70.926351 2 9.0010415 47.276052

i15 71.03481 2 9.0013309 38.962535

i15 71.128508 2 9.0013807 46.967949

i15 71.225159 2 9.0034776 43.754384

i15 71.316934 2 9.0004491 35.991149

i15 71.411382 2 9.0047489 36.485807

i15 71.513673 2 9.0012059 43.381501

i15 71.604858 2 9.0037678 42.559512

i15 71.712093 2 9.0002816 45.435674

i15 71.80298 2 9.003142 35.576606

i15 71.907516 2 9.0023543 38.842819

i15 72.017281 2 9.0013381 47.971687

i15 72.112843 2 9.0045236 38.809399

i15 72.206556 2 9.0045578 41.626046

i15 72.299176 2 9.0006852 47.181286

i15 72.394998 2 9.0036109 48.505488

i15 72.501449 2 9.0009084 35.567221

i15 72.595312 2 9.0007925 41.273536

i15 72.689044 2 9.0008082 48.473213

i15 72.796843 2 9.0017574 43.926519

i15 72.901427 2 9.0009216 36.41233

i15 72.998702 2 9.0023939 47.410875

i15 73.08876 2 9.0010826 49.047301

i15 73.18789 2 9.0006999 45.251407

i15 73.297542 2 9.0047973 38.297572

i15 73.402429 2 9.0036584 39.176788

i15 73.501217 2 9.0036179 36.480543

i15 73.599472 2 9.0041106 44.745075

i15 73.695811 2 9.0015192 49.426822

i15 73.788445 2 9.0026326 36.963756

i15 73.880552 2 9.0042732 39.603691

i15 73.989163 2 9.0044106 45.923466

i15 74.083498 2 9.0038225 44.250874

i15 74.174954 2 9.0011136 42.412556

i15 74.272158 2 9.0026577 38.493055

i15 74.380793 2 9.0027719 48.552184

i15 74.489123 2 9.0031911 38.474285

i15 74.596414 2 9.0046488 38.412253

i15 74.692679 2 9.0021312 39.477337

i15 74.784441 2 9.004117 48.646492

i15 74.882446 2 9.0048596 44.051271

i15 74.983519 2 9.002534 49.105671

i15 75.089998 2 9.0048033 45.134896

i15 75.196433 2 9.002117 38.471309

i15 75.294486 2 9.002812 39.182968

i15 75.40323 2 9.002817 49.881193

i15 75.503262 2 9.0015324 39.292383

i15 75.599348 2 9.0041945 36.543949

i15 75.697507 2 9.0047833 43.324276

i15 75.798744 2 9.0022941 42.379594

i15 75.902858 2 9.0019289 47.03021

i15 76.002014 2 9.0015206 42.630014

i15 76.105026 2 9.0022571 42.177015

i15 76.209519 2 9.0015125 39.492673

i15 76.310428 2 9.0043519 44.674344

i15 76.419511 2 9.0040181 37.743399

i15 76.511808 2 9.0004683 47.695402

i15 76.611255 2 9.0047693 35.360522

i15 76.718863 2 9.0009101 49.804511

i15 76.813163 2 9.0003578 44.151759

i15 76.913867 2 9.0034016 38.080573

i15 77.015906 2 9.0001104 35.374256

i15 77.1123 2 9.0024639 46.247363

i15 77.210549 2 9.0029627 35.368304

i15 77.308469 2 9.0037908 47.788794

i15 77.411674 2 9.0043341 41.17465

i15 77.506133 2 9.0036222 44.081944

i15 77.605499 2 9.0030039 41.161374

i15 77.714131 2 9.0031202 47.52052

i15 77.823014 2 9.002986 35.65077

i15 77.927004 2 9.0027441 49.636954

i15 78.018092 2 9.0004033 42.544862

i15 78.110618 2 9.0016244 49.229965

i15 78.210627 2 9.0003634 42.945442

i15 78.312799 2 9.0019393 35.488021

i15 78.414653 2 9.0038334 46.785056

i15 78.518947 2 9.0032881 46.119635

i15 78.611469 2 9.0045139 38.447046

i15 78.712664 2 9.0020671 45.467263

i15 78.807763 2 9.0007152 42.396533

i15 78.901381 2 9.000845 42.643061

i15 78.998741 2 9.0022331 38.797725

i15 79.106986 2 9.0027371 44.649622

i15 79.21625 2 9.0022213 44.146265

i15 79.32144 2 9.0007799 39.503432

i15 79.421899 2 9.0040689 41.887911

i15 79.527408 2 9.0023083 39.363801

i15 79.625191 2 9.0032734 48.049514

i15 79.723885 2 9.0033275 48.654962

i15 79.826643 2 9.0043176 41.857696

i15 79.916817 2 9.0028903 47.189527

i15 80.025913 2 9.002543 46.371199

i15 80.134733 2 9.0024714 48.298789

i15 80.234926 2 9.001026 44.098196

i15 80.329357 2 9.0003421 36.952082

i15 80.435995 2 9.0024524 42.627267

i15 80.541249 2 9.0009463 42.888445

i15 80.644952 2 9.0009915 35.248817

i15 80.750418 2 9.0042741 48.733246

i15 80.859267 2 9.0041734 36.58332

i15 80.951951 2 9.0002367 48.128485

i15 81.051175 2 9.0047611 43.202728

i15 81.15664 2 9.0030444 43.857619

i15 81.265806 2 9.0026276 39.255988

i15 81.356603 2 9.000577 45.970391

i15 81.464298 2 9.0016306 47.098652

i15 81.555913 2 9.0037632 39.904927

i15 81.651936 2 9.001487 42.910191

i15 81.746219 2 9.0009515 44.618034

i15 81.851271 2 9.0046482 37.326338

i15 81.947377 2 9.0022893 35.703189

i15 82.04024 2 9.0031739 36.060506

i15 82.133066 2 9.0040948 48.524945

i15 82.235299 2 9.0006094 45.529295

i15 82.341424 2 9.0032327 41.331449

i15 82.439545 2 9.0038597 48.475273

i15 82.530661 2 9.0014905 43.392946

i15 82.635838 2 9.0000622 39.595222

i15 82.739696 2 9.0049525 48.11704

i15 82.844931 2 9.0034663 46.167018

i15 82.953772 2 9.0033739 41.176253

i15 83.04859 2 9.0023033 43.666943

i15 83.155084 2 9.0045579 43.636957

i15 83.257724 2 9.0006654 36.402029

i15 83.358409 2 9.0037288 35.077369

i15 83.465507 2 9.000379 48.134208

i15 83.571726 2 9.0029083 41.720583

i15 83.665502 2 9.0028797 37.697618

i15 83.76184 2 9.0002895 44.551194

i15 83.85479 2 9.0010868 39.636424

i15 83.945011 2 9.0046135 37.445596

i15 84.042092 2 9.0012801 49.81939

i15 84.142579 2 9.0045413 40.298182

i15 84.240895 2 9.0049735 46.066759

i15 84.341584 2 9.0030322 37.140698

i15 84.447575 2 9.000789 38.77987

i15 84.540394 2 9.0017172 49.273915

i15 84.644524 2 9.0013352 46.563936

i15 84.739332 2 9.0002741 43.384248

i15 84.848277 2 9.0000782 41.848082

i15 84.956301 2 9.0008025 49.67953

i15 85.062632 2 9.0032198 46.519071

i15 85.167401 2 9.002199 40.002897

i15 85.276779 2 9.0015697 47.538603

i15 85.372565 2 9.0045318 45.96856

i15 85.468421 2 9.0024235 47.572939

i15 85.566177 2 9.0034158 37.07569

i15 85.671906 2 9.0014351 40.61567

i15 85.772701 2 9.0043887 38.844192

i15 85.871344 2 9.0044937 47.615972

i15 85.967301 2 9.0022838 40.931327

i15 86.058735 2 9.0045967 47.097279

i15 86.161472 2 9.0006075 40.260642

i15 86.257101 2 9.0037268 40.788263

i15 86.353663 2 9.0009126 39.146801

i15 86.448598 2 9.0047258 44.246982

i15 86.544898 2 9.0021735 43.420415

i15 86.64765 2 9.0031698 47.482293

i15 86.739405 2 9.0001615 45.551499

i15 86.83907 2 9.0042445 35.580726

i15 86.930241 2 9.0018204 37.775674

i15 87.021189 2 9.0046198 39.336104

i15 87.129917 2 9.0046403 40.221728

i15 87.233981 2 9.0043248 35.865481

i15 87.32602 2 9.0010327 39.030977

i15 87.432178 2 9.0036233 44.242862

i15 87.541843 2 9.0027075 44.487559

i15 87.64341 2 9.0048885 41.116509

i15 87.742001 2 9.0000447 44.139169

i15 87.851317 2 9.0044776 41.341291

i15 87.943069 2 9.0014729 45.925984

i15 88.043683 2 9.0046074 43.59873

i15 88.149197 2 9.0028413 46.302758

i15 88.245557 2 9.0002288 36.022508

i15 88.352738 2 9.0017961 43.36502

i15 88.457379 2 9.0009032 46.828089

i15 88.559874 2 9.0021561 49.975272

i15 88.658103 2 9.002675 44.928655

i15 88.76124 2 9.0032864 46.883713

i15 88.853325 2 9.0049486 35.568823

i15 88.947547 2 9.0044741 40.858536

i15 89.048407 2 9.0023622 35.947428

i15 89.150214 2 9.0043031 47.809395

i15 89.2466 2 9.0016644 35.838928

i15 89.346983 2 9.0000288 45.908129

i15 89.452173 2 9.0035876 48.223022

i15 89.552553 2 9.0019551 48.720428

i15 89.658533 2 9.0047234 39.903325

i15 89.754198 2 9.0028059 43.325191

i15 89.861355 2 9.0043979 42.142451

i15 89.952397 2 9.0021025 48.444829

i15 90.056701 2 9.0015465 36.27659

i15 90.166458 2 9.0005385 37.563252

i15 90.264155 2 9.0015897 49.349224

i15 90.365138 2 9.0043546 42.060275

i15 90.474935 2 9.0033067 39.725696

i15 90.582278 2 9.0047122 44.326869

i15 90.685028 2 9.0007104 37.731038

i15 90.777416 2 9.0020702 35.895467

i15 90.873309 2 9.0049251 46.265904

i15 90.981423 2 9.0005599 45.567522

i15 91.084674 2 9.0010568 46.432088

i15 91.18712 2 9.0023592 47.530134

i15 91.278153 2 9.0000733 48.162134

i15 91.384908 2 9.0020673 49.489083

i15 91.480047 2 9.0006756 35.839386

i15 91.58339 2 9.0010807 45.789558

i15 91.682044 2 9.0011742 48.930332

i15 91.774997 2 9.0019681 45.543716

i15 91.88435 2 9.0013639 37.596443

i15 91.986618 2 9.0028445 40.752783

i15 92.083811 2 9.0043993 48.3361

i15 92.17521 2 9.0017468 49.435978

i15 92.267036 2 9.0036685 49.593692

i15 92.368443 2 9.0010093 38.748511

i15 92.468531 2 9.00467 42.394702

i15 92.570311 2 9.0016379 43.117348

i15 92.673811 2 9.0018858 35.968487

i15 92.771759 2 9.0026852 42.355102

i15 92.867533 2 9.0006581 38.372423

i15 92.966313 2 9.0006255 49.793066

i15 93.066623 2 9.0040634 47.116049

i15 93.170704 2 9.0037311 35.399206

i15 93.278397 2 9.0047866 39.785211

i15 93.370486 2 9.0014444 43.913929

i15 93.46368 2 9.0019975 39.673049

i15 93.57067 2 9.0037564 42.961236

i15 93.664948 2 9.0032261 46.398668

i15 93.771344 2 9.0005785 41.184493

i15 93.879436 2 9.0012354 41.532654

i15 93.9883 2 9.0011204 41.367158

i15 94.09727 2 9.0008989 39.226688

i15 94.198654 2 9.0032628 38.557606

i15 94.304591 2 9.0010739 46.834956

i15 94.411481 2 9.002933 48.196698

i15 94.511685 2 9.0014773 40.536927

i15 94.603429 2 9.003481 44.23714

i15 94.706098 2 9.0045603 45.969704

i15 94.799352 2 9.0000528 47.27651

i15 94.890769 2 9.0023828 38.843963

i15 94.997933 2 9.0039678 47.675258

i15 95.107159 2 9.0034905 40.577672

i15 95.202307 2 9.00209 48.685635

i15 95.303358 2 9.0047875 48.914766

i15 95.395685 2 9.0012072 49.575151

i15 95.487227 2 9.0034121 43.55066

i15 95.581983 2 9.0024035 43.751408

i15 95.684522 2 9.0036128 36.761864

i15 95.791449 2 9.0004342 46.889664

i15 95.882009 2 9.0036218 49.02876

i15 95.991277 2 9.0031027 35.05219

i15 96.095597 2 9.0025308 39.654279

i15 96.201243 2 9.0006328 47.822671

i15 96.303458 2 9.0021663 47.401719

i15 96.394324 2 9.0000467 36.417366

i15 96.504156 2 9.0039638 46.106588

i15 96.60233 2 9.0045379 41.826336

i15 96.699773 2 9.0008426 40.310314

i15 96.806519 2 9.0028457 42.924611

i15 96.904029 2 9.0040831 40.883028

i15 97.013228 2 9.003633 44.605215

i15 97.115411 2 9.0001977 40.646343

i15 97.214498 2 9.0048585 45.901262

i15 97.315294 2 9.0028107 35.000229

i15 97.4137 2 9.0031529 38.110788

i15 97.511072 2 9.0045288 42.549898

i15 97.616155 2 9.0031943 47.925678

i15 97.724279 2 9.0038188 35.724477

i15 97.824764 2 9.0020819 45.548294

i15 97.923712 2 9.0018818 36.410727

i15 98.020629 2 9.0037128 47.825876

i15 98.123561 2 9.004529 46.571718

i15 98.228684 2 9.0031547 41.368531

i15 98.326532 2 9.0040546 38.870974

i15 98.428311 2 9.001023 40.679534

i15 98.531969 2 9.0011128 37.304821

i15 98.628974 2 9.0028553 41.276054

i15 98.728984 2 9.0015931 47.821069

i15 98.83084 2 9.0034851 47.81672

i15 98.93458 2 9.0034931 48.94315

i15 99.030402 2 9.0014181 42.223711

i15 99.136774 2 9.0037951 42.399738

i15 99.231109 2 9.0032077 41.81306

i15 99.322723 2 9.0003407 43.74889

i15 99.418984 2 9.0028279 37.414008

i15 99.511852 2 9.0037069 42.999463

i15 99.603256 2 9.0010502 36.497939

i15 99.693975 2 9.0040785 40.239354

i15 99.801984 2 9.0048187 46.301842

i15 99.892424 2 9.0031255 36.259652

i15 99.992675 2 9.0016225 41.950402

i15 100.09217 2 9.0008772 38.180145

i15 100.18792 2 9.0038747 39.587668

i15 100.29294 2 9.0025978 35.072104

i15 100.39601 2 9.0032837 49.497781

i15 100.48738 2 9.0006596 48.587893

i15 100.58655 2 9.0002303 44.227068

i15 100.68411 2 9.0014206 48.578279

i15 100.78114 2 9.003143 46.717071

i15 100.87593 2 9.0020974 48.72615

i15 100.9689 2 9.0028706 38.42118

i15 101.07288 2 9.0026412 37.165191

i15 101.16721 2 9.0020598 47.437657

i15 101.2604 2 9.0026123 42.110862

i15 101.36724 2 9.0045294 41.624902

i15 101.46246 2 9.0030559 47.477715

i15 101.56462 2 9.004644 46.737215

i15 101.66963 2 9.0033762 43.509

i15 101.77507 2 9.0016907 39.540056

i15 101.87229 2 9.0032119 47.403551

i15 101.975 2 9.0042542 35.943079

i15 102.07869 2 9.0043111 48.935825

i15 102.18716 2 9.0045898 44.120857

i15 102.27809 2 9.0024058 46.084155

i15 102.37125 2 9.0030002 47.636345

i15 102.4689 2 9.0040886 35.654891

i15 102.55953 2 9.0022101 48.56981

i15 102.6518 2 9.003685 48.910646

i15 102.75749 2 9.0017412 35.640928

i15 102.84785 2 9.0001304 37.184876

i15 102.94944 2 9.0022867 42.339078

i15 103.04163 2 9.0038458 42.522429

i15 103.14914 2 9.0000867 40.038606

i15 103.24936 2 9.0036094 38.290019

i15 103.35542 2 9.0013037 41.133219

i15 103.45203 2 9.0034353 39.811306

i15 103.55282 2 9.0013963 37.155348

i15 103.65352 2 9.0044466 49.986946

i15 103.75722 2 9.0044958 41.905079

i15 103.86371 2 9.0017503 49.918733

i15 103.96643 2 9.0027792 44.57088

i15 104.06664 2 9.0013137 49.539213

i15 104.17586 2 9.0008465 37.857164

i15 104.27362 2 9.0018379 48.233094

i15 104.37911 2 9.0000943 46.111853

i15 104.48132 2 9.0016332 40.462763

i15 104.57361 2 9.0030913 48.444371

i15 104.67495 2 9.0004947 36.395162

i15 104.77124 2 9.0029519 36.855943

i15 104.87637 2 9.0015768 37.524568

i15 104.97398 2 9.0027137 44.367156

i15 105.07717 2 9.003268 42.298105

i15 105.17448 2 9.0047108 38.13322

i15 105.27687 2 9.0010662 36.739889

i15 105.38173 2 9.0049487 37.579733

i15 105.48598 2 9.0044544 45.080646

i15 105.5917 2 9.0024801 37.520677

i15 105.69415 2 9.0037736 45.375015

i15 105.8029 2 9.0037801 36.285975

i15 105.90332 2 9.0021003 35.132535

i15 105.99705 2 9.0021196 48.847698

i15 106.1058 2 9.0021203 36.943155

i15 106.20473 2 9.0019425 44.939413

i15 106.30741 2 9.0030034 44.09728

i15 106.41593 2 9.0032388 37.189225

i15 106.51563 2 9.0022787 41.212648

i15 106.61574 2 9.0009203 49.241868

i15 106.7127 2 9.0027101 39.86258

i15 106.80496 2 9.0041969 38.876696

i15 106.91373 2 9.0041707 39.197389

i15 107.0057 2 9.0009481 46.146188

i15 107.10988 2 9.0005172 46.57126

i15 107.21205 2 9.0021029 41.487103

i15 107.31643 2 9.0014675 38.163664

i15 107.42563 2 9.0010101 43.856245

i15 107.52592 2 9.0044724 39.611703

i15 107.61632 2 9.0028167 43.848463

i15 107.7263 2 9.0015917 41.62742

i15 107.8278 2 9.0038408 46.825571

i15 107.92401 2 9.0013712 35.626049

i15 108.02819 2 9.0009474 41.038453

i15 108.13217 2 9.0007149 49.354259

i15 108.22571 2 9.000924 40.755987

i15 108.32362 2 9.0017616 47.506099

i15 108.42927 2 9.0048549 39.385776

i15 108.52911 2 9.0037593 42.358077

i15 108.63413 2 9.0024949 37.601708

i15 108.74043 2 9.0049403 39.389209

i15 108.83247 2 9.0016475 41.46879

i15 108.93847 2 9.0043962 42.906528

i15 109.02908 2 9.0025373 45.566606

i15 109.12641 2 9.0039535 46.669231

i15 109.22192 2 9.0021856 46.115515

i15 109.32781 2 9.0000474 39.51419

i15 109.42782 2 9.0037859 39.101479

i15 109.52975 2 9.0005984 40.984203

i15 109.63302 2 9.001078 48.403627

i15 109.73096 2 9.0018856 46.948034

i15 109.82887 2 9.0027247 48.912248

i15 109.93492 2 9.0004223 35.225927

i15 110.03241 2 9.0016844 39.660459

i15 110.12801 2 9.0048324 46.221955

i15 110.232 2 9.0045886 41.949028

i15 110.32261 2 9.002722 38.53586

i15 110.41797 2 9.001114 37.46574

i15 110.52527 2 9.0025589 44.602239

i15 110.61822 2 9.0033614 41.417058

i15 110.70978 2 9.0005438 41.303751

i15 110.81885 2 9.0002262 40.647487

i15 110.91533 2 9.0024878 45.604833

i15 111.00979 2 9.0017777 36.768502

i15 111.10963 2 9.0006851 45.170376

i15 111.21543 2 9.0036307 44.283378

i15 111.31702 2 9.0007906 48.99534

i15 111.41024 2 9.001322 43.707917

i15 111.51161 2 9.0036929 48.026166

i15 111.61937 2 9.0046864 39.700746

i15 111.71541 2 9.0023895 35.787654

i15 111.82432 2 9.0022287 44.186781

i15 111.92144 2 9.0038635 44.011213

i15 112.01354 2 9.0005024 44.479319

i15 112.12184 2 9.000956 43.250798

i15 112.21806 2 9.0034822 46.408968

i15 112.32105 2 9.0042441 38.516632

i15 112.4121 2 9.001939 42.445747

i15 112.51387 2 9.0039125 44.897982

i15 112.61872 2 9.0028166 39.826642

i15 112.72865 2 9.0016312 48.184567

i15 112.82043 2 9.0036051 43.679075

i15 112.91535 2 9.0024301 40.494809

i15 113.01481 2 9.0017163 40.144359

i15 113.1187 2 9.0015723 40.902714

i15 113.21516 2 9.0038599 39.506636

i15 113.31634 2 9.0014312 41.05791

i15 113.4161 2 9.0004158 44.314966

i15 113.5219 2 9.0033642 40.8139

i15 113.6242 2 9.0048131 47.508159

i15 113.73317 2 9.0045879 38.852204

i15 113.83361 2 9.0028999 45.540969

i15 113.9252 2 9.000053 38.307873

i15 114.02668 2 9.0023235 36.508927

i15 114.12843 2 9.0043215 37.393636

i15 114.2196 2 9.0019022 48.275899

i15 114.31181 2 9.0034368 35.025408

i15 114.41299 2 9.0010011 46.590717

i15 114.51094 2 9.0018038 36.44781

i15 114.60758 2 9.0039077 38.221577

i15 114.70118 2 9.0040616 43.858306

i15 114.80478 2 9.0042054 39.078131

i15 114.89578 2 9.0019573 47.031355

i15 114.99233 2 9.0041503 42.333585

i15 115.08901 2 9.0012241 43.945289

i15 115.19493 2 9.0040452 46.552261

i15 115.30427 2 9.0034538 46.407824

i15 115.40986 2 9.0016144 38.813061

i15 115.50725 2 9.002972 40.677474

i15 115.60759 2 9.0013798 37.838393

i15 115.704 2 9.0037147 38.093162

i15 115.79743 2 9.0040349 47.114904

i15 115.90411 2 9.0011014 35.695635

i15 115.99814 2 9.0008192 38.016938

i15 116.0888 2 9.0039122 36.854341

i15 116.19356 2 9.0028956 37.939568

i15 116.28405 2 9.0011597 41.891574

i15 116.39323 2 9.0007224 38.415228

i15 116.49873 2 9.003968 38.706621

i15 116.59802 2 9.0034313 38.242636

i15 116.70776 2 9.0024437 38.404012

i15 116.81075 2 9.0031991 41.611626

i15 116.92014 2 9.002554 35.914924

i15 117.01182 2 9.0046261 41.226611

i15 117.11219 2 9.0030001 45.625434

i15 117.21983 2 9.0041083 46.434148

i15 117.3256 2 9.0020922 46.996562

i15 117.41722 2 9.0042144 36.343659

i15 117.51056 2 9.0046259 35.193881

i15 117.60087 2 9.0030594 47.960471

i15 117.69392 2 9.0037547 41.714403

i15 117.79774 2 9.0036806 39.298335
i15 117.8923 2 9.0028676 35.002518
i15 117.98551 2 9.0034119 37.51793
i15 118.0902 2 9.0024628 46.086444
i15 118.19815 2 9.0032591 47.043487
i15 118.30314 2 9.0020225 39.191437
i15 118.39664 2 9.002275 47.687619
i15 118.50577 2 9.0018887 37.376239
i15 118.60447 2 9.0019342 37.780252
i15 118.70502 2 9.0001373 38.150388
i15 118.80839 2 9.0005082 47.294822
i15 118.9182 2 9.0044545 49.102466
i15 119.02396 2 9.0024406 45.964897
i15 119.11614 2 9.0040094 48.521511
i15 119.20617 2 9.0027212 46.418582
i15 119.31131 2 9.0013314 36.026629
i15 119.40513 2 9.0012622 42.297876
i15 119.51095 2 9.0041849 38.192506
i15 119.60661 2 9.0022729 36.386235
i15 119.71519 2 9.002442 39.168089
i15 119.81775 2 9.0036339 38.733403
i15 119.92017 2 9.004961 46.307564
e
</CsScore>
</CsoundSynthesizer>
<bsbPanel>
<label>Widgets</label>
<objectName/>
<x>100</x>
<y>100</y>
<width>320</width>
<height>240</height>
<visible>true</visible>
<uuid/>
<bgcolor mode="nobackground">
<r>255</r>
<g>255</g>
<b>255</b>
</bgcolor>
</bsbPanel>
<bsbPresets>
</bsbPresets>
